<?php
declare(strict_types=1);

namespace popp\r12\zestaw08;
use popp\r12\zestaw06\Request;

require_once("vendor/autoload.php");

use popp\test\BaseUnit;

class Batch08Test extends BaseUnit 
{

    public function testRunner()
    {
        $val = $this->capture(function() { Runner::run(); });
        self::assertRegexp("/wybierz nazwę placówki/", $val);
        //print $val;
        
        $val = $this->capture(function() { Runner::run2(); });
        self::assertRegexp("/nazwa jest wymaganym polem/", $val);
        //print $val;

        $val = $this->capture(function() { Runner::run3(); });
        self::assertRegexp("/Lista placówek/", $val);
        //print $val;
    }

    public function testPageController() {
        $test = new class extends PageController {
            public function process() {} 
        };
        $controller = new $test();
        $controller->init();
        $request = $controller->getRequest();
        self::assertTrue($request instanceof Request);

        ob_start();
        $controller->forward(__DIR__."/error.php");
        $output = ob_get_contents();
        ob_end_clean();
        self::assertEquals($output, "to jest błąd\n");
    }

}
