<?php

namespace popp\r08\zestaw01;

require_once("vendor/autoload.php");

use popp\r08\zestaw01\Lecture;
use popp\r08\zestaw01\Seminar;
use popp\r08\zestaw01\Runner;
use popp\test\BaseUnit;

class Batch01Test extends BaseUnit 
{
    function testLectureAndSeminar()
    {
        $lecture = new Lecture(5, Lesson::FIXED);
        self::assertEquals($lecture->cost(), 30);
        self::assertEquals($lecture->chargeType(), "stawka stała");
        $seminar= new Seminar(3, Lesson::TIMED);
        self::assertEquals($seminar->cost(), 15);
        self::assertEquals($seminar->chargeType(), "stawka godzinowa");
    }

    function testRunner()
    {
        $val = $this->capture(function() { Runner::run(); });
        self::assertEquals($val, "30 (stawka stała)\n15 (stawka godzinowa)\n");
    }

}
