<?php
declare(strict_types = 1);

namespace popp\r13\zestaw02;

use popp\r12\zestaw10\TableCreator;
use popp\r12\zestaw06\Conf;
use popp\r13\zestaw01\Registry;
use popp\r13\zestaw01\Venue;
use popp\r13\zestaw01\SpaceMapper;
use popp\r13\zestaw01\Space;

class Runner
{


    public static function run()
    {
        $venue1id = self::forRun1and3();
        $mapper = new VenueMapper();
        $venue = $mapper->find($venue1id);

        // mamy obiekt placówki i sprawdzamy, czy zdobyliśmy w niej miejsca
        $acquiredvenue1 = $mapper->find($venue1id);
        print $acquiredvenue1->getName() . "\n";
        $spaces = $acquiredvenue1->getSpaces();

        foreach ($spaces as $space) {
            print "    ".$space->getName() . "\n";
        }
    }

    public static function run3()
    {
        $venue1id = self::forRun1and3();
        $mapper = new VenueMapper();
        $venue = $mapper->find($venue1id);

        // mamy obiekt placówki i sprawdzamy, czy zdobyliśmy w niej miejsca
        $acquiredvenue1 = $mapper->find($venue1id);
        print $acquiredvenue1->getName() . "\n";
        $spaces = $acquiredvenue1->getSpaces2();

        foreach ($spaces as $space) {
            print "    " . $space->getName() . "\n";
        }
    }

    private static function forRun1and3()
    {
        // konfiguracja wstępna

        // test integracji SpaceMapper i VenueMapper
        self::setUp();
        $vmapper = new VenueMapper();

        $venue1 = new Venue(-1, "Pod Pełnym Kuflem");
        $vmapper->insert($venue1);
        $venue1id = $venue1->getId();

        $venue2 = new Venue(-1, "Pod Pustym Kuflem");
        $vmapper->insert($venue2);

        $space1 = new Space(-1, "Scena na Poddaszu", $venue1);
        $space2 = new Space(-1, "Piwnica", $venue1);
        $smapper = new SpaceMapper();
        $smapper->insert($space1);
        $smapper->insert($space2);

        return $venue1id;
    }

    public static function run2()
    {
        // konfiguracja wstępna
        self::setUp();
        $vmapper = new VenueMapper();

        $venue1 = new Venue(-1, "Pod Pełnym Kuflem");
        $vmapper->insert($venue1);
        $venue1id = $venue1->getId();

        $venue2 = new Venue(-1, "Pod Pustym Kuflem");
        $vmapper->insert($venue2);

        $collection = $vmapper->findAll();

        foreach ($collection as $venue) {
            print $venue->getName() . "\n";
        }
    }


    private function setUp()
    {
        $config = __DIR__ . "/../zestaw01/data/woo_options.ini";
        $options = parse_ini_file($config, true);
        Registry::reset();
        $reg = Registry::instance();
        $conf = new Conf($options['config']);
        $reg->setConf($conf);
        $reg = Registry::instance();
        $dsn = $reg->getDSN();

        if (is_null($dsn)) {
            throw new AppException("Brak DSN");
        }

        $pdo = new \PDO($dsn);
        $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
        $autoincrement = "AUTOINCREMENT";

        $pdo->query("DROP TABLE IF EXISTS venue");
        $pdo->query("CREATE TABLE venue ( id INTEGER PRIMARY KEY
            $autoincrement, name TEXT )");
        $pdo->query("INSERT into venue ( name ) values ('bob')");
        $pdo->query("DROP TABLE  IF EXISTS space");
        $pdo->query("CREATE TABLE space ( id INTEGER PRIMARY KEY
            $autoincrement, venue INTEGER, name TEXT )");
        $pdo->query("DROP TABLE IF EXISTS event");
        $pdo->query("CREATE TABLE event ( id INTEGER PRIMARY KEY
            $autoincrement, space INTEGER, start long, duration int, name text )");
    }
}
