<?php

namespace popp\r08\zestaw02;

require_once("vendor/autoload.php");

use popp\test\BaseUnit;

class Batch02Test extends BaseUnit 
{
    function testLectureAndSeminar()
    {
        $seminar = new Seminar(4, new TimedCostStrategy());
        self::assertEquals("stawka godzinowa", $seminar->chargeType());
        self::assertEquals(4, $seminar->getDuration());
        self::assertEquals(20, $seminar->cost());

        $lecture = new Lecture(4, new FixedCostStrategy());
        self::assertEquals("stawka stała", $lecture->chargeType());
        self::assertEquals(4, $lecture->getDuration());
        self::assertEquals(30, $lecture->cost());
    }

    function testRunner()
    {
        $val = $this->capture(function() { Runner::run(); });
        $expected = "Koszt lekcji: 20. Sposób rozliczania: stawka godzinowa\nKoszt lekcji 30. Sposób rozliczania: stawka stała\n";
        self::assertEquals($val, $expected);
    }

    function testRunner2()
    {
        $val = $this->capture(function() { Runner::run2(); });
        self::assertRegexp("/notification: new/", $val);
        self::assertRegexp("/cost/", $val);
    }


}
