<?php
declare(strict_types = 1);

namespace popp\r13\zestaw01;

use popp\r12\zestaw10\TableCreator;
use popp\r12\zestaw06\Conf;

class Runner
{
    public static function run()
    {
        // konfiguracja wstępna
        self::setUp();
        $mapper = new VenueMapper();
        $venue = new Venue(-1, "Pod Pełnym Kuflem");
        $mapper->insert($venue);
        $venue = new Venue(-1, "Pod Pustym Kuflem");
        $mapper->insert($venue);

/* listing 13.03 */
        $mapper = new VenueMapper();
        $venue = $mapper->find(2);
        print_r($venue);
/* /listing 13.03 */
    }

    public static function run2()
    {
        // konfiguracja wstępna
        self::setUp();

/* listing 13.04 */
        $mapper = new VenueMapper();
        $venue = new Venue(-1, "Pod Pełnym Kuflem");
        // dodanie obiektu do bazy danych
        $mapper->insert($venue);
        // wyszukaj dopiero co wstawiony obiekt - zobaczymy, czy wstawienie się powiodło
        $venue = $mapper->find($venue->getId());
        print_r($venue);
        // modyfikacja obiektu
        $venue->setName("Pod Kuflem Pełnym Piwa");
        // aktualizacja obiektu utrwalonego w bazie danych
        $mapper->update($venue);
        // ponowny kontrolny odczyt z bazy danych
        $venue = $mapper->find($venue->getId());
        print_r($venue);
/* /listing 13.04 */
    }

    public static function run3()
    {
        Registry::reset();

/* listing 13.07 */
        $reg = Registry::instance();

        $collection = $reg->getVenueCollection();
        $collection->add(new Venue(-1, "Szalony Parkiet"));
        $collection->add(new Venue(-1, "Pełny Luz"));
        $collection->add(new Venue(-1, "U Kaczki i Borsuka"));

        foreach ($collection as $venue) {
            print $venue->getName() . "\n";
        }
/* /listing 13.07 */
    }

    public static function run4()
    {
        Registry::reset();

/* listing 13.09 */
        $genvencoll = new GenVenueCollection();
        $genvencoll->add(new Venue(-1, "Szalony Parkiet"));
        $genvencoll->add(new Venue(-1, "Pełny Luz"));
        $genvencoll->add(new Venue(-1, "U Kaczki i Borsuka"));

        $gen = $genvencoll->getGenerator();

        foreach ($gen as $wrapper) {
            print_r($wrapper);
        }
/* /listing 13.09 */
    }

    public static function run5()
    {
        self::setUp();
        Registry::reset();
        $reg = Registry::instance();

        $venue = new Venue(-1, "Pełny Luz");
        $collection = $reg->getSpaceCollection();
        $collection->add(new Space(-1, "Wielka Scena", $venue));

        $venue->setSpaces($collection);
        $venue->addSpace(new Space(-1, "Piwnica"));

        $coll2 = $venue->getSpaces();
        foreach ($coll2 as $space) {
            print_r($space);
        }
    }

    private function setUp()
    {
        $config = __DIR__ . "/data/woo_options.ini";
        $options = parse_ini_file($config, true);
        Registry::reset();
        $reg = Registry::instance();
        $conf = new Conf($options['config']);
        $reg->setConf($conf);
        $reg = Registry::instance();
        $dsn = $reg->getDSN();

        if (is_null($dsn)) {
            throw new AppException("Brak DSN");
        }

        $pdo = new \PDO($dsn);
        $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);

        $autoincrement = "AUTOINCREMENT";

        $pdo->query("DROP TABLE IF EXISTS venue");
        $pdo->query("CREATE TABLE venue ( id INTEGER PRIMARY KEY
            $autoincrement, name TEXT )");
        $pdo->query("INSERT into venue ( name ) values ('bob')");
        $pdo->query("DROP TABLE  IF EXISTS space");
        $pdo->query("CREATE TABLE space ( id INTEGER PRIMARY KEY
            $autoincrement, venue INTEGER, name TEXT )");
        $pdo->query("DROP TABLE IF EXISTS event");
        $pdo->query("CREATE TABLE event ( id INTEGER PRIMARY KEY
            $autoincrement, space INTEGER, start long, duration int, name text )");
    }
}
