<?php
declare(strict_types = 1);

namespace popp\r12\zestaw06;

/* listing 12.25 */
class TemplateViewComponent implements ViewComponent
{
    private $name = null;

    public function __construct(string $name)
    {
        $this->name = $name;
    }

    public function render(Request $request)
    {
        $reg = Registry::instance();
        $conf = $reg->getConf();
        $path = $conf->get("templatepath");

        if (is_null($path)) {
            throw new AppException("nie odnaleziono katalogu z szablonami");
        }

        $fullpath = "{$path}/{$this->name}.php";

        if (! file_exists($fullpath)) {
            throw new AppException("brak szablonu na ścieżce {$fullpath}");
        }

        include($fullpath);
    }
}
/* /listing 12.25 */
