<?php
declare(strict_types=1);

namespace popp\r05\zestaw07;

class ClassInfo
{

/* listing 05.36 */
    // class ClassInfo

    public static function getData(\ReflectionClass $class)
    {
        $details = "";
        $name = $class->getName();
        if ($class->isUserDefined()) {
            $details .= "$name to klasa definiowana przez użytkownika\n";
        }
        if ($class->isInternal()) {
            $details .= "$name to klasa wbudowana";
        }
        if ($class->isInterface()) {
            $details .= "$name definiuje interfejs\n";
        }
        if ($class->isAbstract()) {
            $details .= "$name to klasa abstrakcyjna\n";
        }
        if ($class->isFinal()) {
            $details .= "$name to klasa finalna\n";
        }
        if ($class->isInstantiable()) {
            $details .= "Można tworzyć obiekty klasy $name\n";
        } else {
            $details .= "Nie można tworzyć obiektów klasy $name\n";
        }

        if ($class->isCloneable()) {
            $details .= "Można klonować obiekty klasy $name\n";
        } else {
            $details .= "Nie można klonować obiektów klasy $name\n";
        }
        return $details;
    }
/* /listing 05.36 */


/* listing 05.41 */

    // class ClassInfo
    public static function methodData(\ReflectionMethod $method)
    {
        $details = "";
        $name = $method->getName();
        if ($method->isUserDefined()) {
            $details .= "$name to metoda definiowana przez użytkownika\n";
        }
        if ($method->isInternal()) {
            $details .= "$name to metoda wbudowana\n";
        }
        if ($method->isAbstract()) {
            $details .= "$name to metoda abstrakcyjna\n";
        }
        if ($method->isPublic()) {
            $details .= "$name to metoda publiczna\n";
        }
        if ($method->isProtected()) {
            $details .= "$name to metoda chroniona\n";
        }
        if ($method->isPrivate()) {
            $details .= "$name to metoda prywatna\n";
        }
        if ($method->isStatic()) {
            $details .= "$name to metoda statyczna\n";
        }
        if ($method->isFinal()) {
            $details .= "$name to metoda finalna\n";
        }
        if ($method->isConstructor()) {
            $details .= "$name to konstructor\n";
        }
        if ($method->returnsReference()) {
            $details .= "$name zwraca referencję (nie wartość)\n";
        }
        return $details;
    }
/* /listing 05.41 */

/* listing 05.45 */

    // class ClassInfo
    public function argData(\ReflectionParameter $arg)
    {
        $details = "";
        $declaringclass = $arg->getDeclaringClass();
        $name  = $arg->getName();
        $class = $arg->getClass();
        $position = $arg->getPosition();
        $details .= "\$$name na pozycji $position\n";
        if (! empty($class)) {
            $classname = $class->getName();
            $details .= "\$$name musi być obiektem klasy $classname\n";
        }
      
        if ($arg->isPassedByReference()) {
            $details .= "\$$name jest przekazywany przez referencję\n";
        }

        if ($arg->isDefaultValueAvailable()) {
            $def = $arg->getDefaultValue();
            $details .= "\$$name ma wartość domyślną: $def\n";
        }

        if ($arg->allowsNull()) {
            $details .= "\$$name może być pusty - null\n";
        }

        return $details;
    }
/* /listing 05.45 */
}
