<?php
declare(strict_types=1);

namespace popp\r04\zestaw11;

class Runner
{
    public static function run()
    {
        self::init();
    }

    public static function run2()
    {
        self::init2();
    }

/* listing 04.66 */
    public static function init()
    {
        try {
            $fh = fopen(__DIR__ . "/log.txt", "a");
            fputs($fh, "start\n");
            $conf = new Conf(dirname(__FILE__) . "/conf.broken.xml");
            print "user: " . $conf->get('user') . "\n";
            print "host: " . $conf->get('host') . "\n";
            $conf->set("pass", "newpass");
            $conf->write();
            fputs($fh, "end\n");
            fclose($fh);
        } catch (FileException $e) {
            // błąd uprawnień lub brak pliku
            fputs($fh, "file exception\n");
            throw $e;
        } catch (XmlException $e) {
            fputs($fh, "xml exception\n");
            // wadliwy XML
        } catch (ConfException $e) {
            fputs($fh, "conf exception\n");
            // zły rodzaj pliku XML
        } catch (\Exception $e) {
            fputs($fh, "general exception\n");
            // zabezpieczenie: nie powinno dojść do tego wywołania
        }
    }
/* /listing 04.66 */

    public static function init2()
    {
        $fh = fopen(__DIR__ . "/log.txt", "w");
        try {
            fputs($fh, "start\n");
            $conf = new Conf(dirname(__FILE__) . "/conf.not-there.xml");
            print "user: " . $conf->get('user') . "\n";
            print "host: " . $conf->get('host') . "\n";
            $conf->set("pass", "newpass");
            $conf->write();
        } catch (FileException $e) {
            // błąd uprawnień lub brak pliku
            fputs($fh, "file exception\n");
            //throw $e;
        } catch (XmlException $e) {
            fputs($fh, "xml exception\n");
            // wadliwy XML
        } catch (ConfException $e) {
            fputs($fh, "conf exception\n");
            // zły rodzaj pliku XML
        } catch (Exception $e) {
            fputs($fh, "general exception\n");
            // zabezpieczenie: nie powinno dojść do tego wywołania
        } finally {
            fputs($fh, "end\n");
            fclose($fh);
        }
    }

    public static function init3()
    {
        try {
            eval("błędny kod");
        } catch (\Error $e) {
            print get_class($e) . "\n";
        } catch (\Exception $e) {
            // obsługa wyjątku
        }
    }
}
