<?php
declare(strict_types=1);

namespace popp\r04\zestaw08;

class ProcessSale
{
    private $callbacks;

    public function registerCallback($callback)
    {
        if (! is_callable($callback)) {
            throw new Exception("Niepoprawne wywołanie zwrotne");
        }
        $this->callbacks[] = $callback;
    }

    public function sale($product)
    {
        print "{$product->name}: przetwarzanie sprzedaży \n";
        foreach ($this->callbacks as $callback) {
            call_user_func($callback, $product);
        }
    }
}
