<?php

namespace popp\r03;

require_once("vendor/autoload.php");

use popp\r03\zestaw11\ShopProduct;
use popp\r03\zestaw11\BookProduct;
use popp\r03\zestaw11\CdProduct;
use popp\r03\zestaw11\ShopProductWriter;

class Batch11Test extends \PHPUnit_Framework_TestCase
{
    public function testShopProcuct()
    {
        $test1 = new ShopProduct("tytuł książki", "imię", "nazwisko", 99, 200);

        self::assertEquals("imię nazwisko", $test1->getProducer());
        self::assertEquals(200, $test1->getNumberOfPages());
        self::assertEquals("tytuł książki ( imię, nazwisko ): liczba stron - 200", $test1->getSummaryLine());

        $test2 = new ShopProduct("tytuł CD", "imię", "nazwisko", 99, 0, 88);
        $test2->setType("cd");
        self::assertEquals("imię nazwisko", $test2->getProducer());
        self::assertEquals(88, $test2->getPlayLength());
        self::assertEquals("tytuł CD ( imię, nazwisko ): czas nagrania - 88", $test2->getSummaryLine());

        $test3 = new CdProduct("tytuł CD", "imię", "nazwisko", 99, 88);
        self::assertEquals("tytuł CD ( imię, nazwisko ): czas nagrania - 88", $test3->getSummaryLine());

        $test4 = new BookProduct("tytuł książki", "imię", "nazwisko", 99, 200);
        self::assertEquals("tytuł książki ( imię, nazwisko ): liczba stron - 200", $test4->getSummaryLine());

        $writer = new ShopProductWriter();

        ob_start();
        $writer->write($test3);
        $out3 = ob_get_contents();
        ob_end_clean();
        self::assertEquals("tytuł CD: imię nazwisko (99)\n", $out3);

        ob_start();
        $writer->write($test4);
        $out4 = ob_get_contents();
        ob_end_clean();
 
        self::assertEquals("tytuł książki: imię nazwisko (99)\n", $out4);
    }
}
