<?php

namespace popp\r03;

require_once("vendor/autoload.php");

// nie ma potrzeby tworzyć kopii w tym zestawie
use popp\r03\zestaw04\ShopProduct;
use popp\r03\zestaw08\ShopProductWriter;
use popp\r03\zestaw08\Runner;

class Batch08Test extends \PHPUnit_Framework_TestCase
{
    public function testProductWriter()
    {
        
        $product = new ShopProduct("tytuł", "imię", "nazwisko", 99);
        self::assertTrue($product instanceof ShopProduct);
        self::assertEquals($product->title, "tytuł");
        self::assertEquals($product->producerFirstName, "imię");
        self::assertEquals($product->producerMainName, "nazwisko");
        self::assertEquals($product->price, 99);
        $spw = new ShopProductWriter();

        ob_start();
        $spw->write($product);
        $output1 = ob_get_contents();
        ob_end_clean();
        self::assertEquals("tytuł: imię nazwisko (99)\n", $output1);
      
        // usuń komentarz, aby wywołać błąd krytyczny wynikający z przekazania złego typu metodzie write()
        // Runner::run1();
    }
}
