<?php
declare(strict_types = 1);

namespace popp\r12\zestaw06;

class CliRequest extends Request
{
    public function init()
    {
        $args = $_SERVER['argv'];

        foreach ($args as $arg) {
            if (preg_match("/^path:(\S+)/", $arg, $matches)) {
                $this->path = $matches[1];
            } else {
                if (strpos($arg, '=')) {
                    list($key, $val) = explode("=", $arg);
                    $this->setProperty($key, $val);
                }
            }
        }

        $this->path = (empty($this->path)) ? "/" : $this->path;
    }

/* listing 12.28 */

    // CliRequest

    public function forward(string $path)
    {
        // dołóż nową ścieżkę na koniec listy argumentów
        // ostatni argument wygrywa
        $_SERVER['argv'][] = "path:{$path}";
        Registry::reset();
        Controller::run();
    }
/* /listing 12.28 */
}
