<?php
declare(strict_types = 1);

namespace popp\r11\zestaw09\commands;

use popp\r11\zestaw09\CommandContext;
use popp\r11\zestaw09\Command;
use popp\r11\zestaw09\Registry;

/* listing 11.52 */
class FeedbackCommand extends Command
{
    public function execute(CommandContext $context): bool
    {
        $msgSystem = Registry::getMessageSystem();
        $email = $context->get('email');
        $msg   = $context->get('msg');
        $topic = $context->get('topic');
        $result = $msgSystem->send($email, $msg, $topic);

        if (! $result) {
            $context->setError($msgSystem->getError());
            return false;
        }

        return true;
    }
}
