<?php
declare(strict_types = 1);

namespace popp\r13\zestaw05;

use popp\r13\zestaw04\Venue;
use popp\r12\zestaw06\AppException;

abstract class PersistenceFactory
{

    abstract public function getMapper(): Mapper;
    abstract public function getDomainObjectFactory(): DomainObjectFactory;
    abstract public function getCollection(array $raw): Collection;

    public static function getFactory($targetclass): PersistenceFactory
    {
        switch ($targetclass) {
            case Venue::class:
                return new VenuePersistenceFactory();
                break;
            case Event::class:
                return new EventPersistenceFactory();
                break;
            case Space::class:
                return new SpacePersistenceFactory();
                break;
            default:
                throw new AppException("Nieznana klasa {$targetclass}");
                break;
        }
    }
}
