<?php
declare(strict_types=1);

namespace popp\r04\zestaw02;

class BookProduct extends ShopProduct
{
    private $numPages = 0;

    public function __construct(
        string $title,
        string $firstName,
        string $mainName,
        float $price,
        int $numPages
    ) {
        parent::__construct(
            $title,
            $firstName,
            $mainName,
            $price
        );
        $this->numPages = $numPages;
    }

    public function getNumberOfPages(): int
    {
        return $this->numPages;
    }

    public function getSummaryLine(): string
    {
        $base = parent::getSummaryLine();
        $base .= ": liczba stron - $this->numPages";
        return $base;
    }

    public function getPrice(): float
    {
        return $this->price;
    }
}
