<?php
declare(strict_types = 1);

namespace popp\dodB\zestaw01;

use popp\dodB\zestaw01\marklogic\MarkParse;

class MarkLogicMarker extends Marker
{
    private $engine;

    public function __construct(string $test)
    {
        parent::__construct($test);
        $this->engine = new MarkParse($test);
    }

    public function mark(string $response): bool
    {
        return $this->engine->evaluate($response);
    }
}
