<?php
declare(strict_types=1);

namespace popp\r09\zestaw14;

use popp\r09\zestaw06\BloggsApptEncoder;

require_once("vendor/autoload.php");

use popp\test\BaseUnit;

class Batch14Test extends BaseUnit
{

    public function testRunner()
    {
        $val = $this->capture(function() { Runner::run(); });
        //print $val;
        self::assertEquals($val, "Dane spotkania zakodowane w formacie BloggsCal\n");
        
    }

    public function testAssembler()
    {
        $assembler = new ObjectAssembler("src/r09/zestaw14/objects.xml");
        $assembler->getComponent("\\popp\\r09\\zestaw11\\TerrainFactory");

        $apptmaker = $assembler->getComponent("\\popp\\r09\\zestaw14\\AppointmentMaker2");
        $out = $apptmaker->makeAppointment();
        self::assertEquals($out, "Dane spotkania zakodowane w formacie BloggsCal\n");
    }


    public function testNaiveEncoder()
    {
        $apptmaker = new AppointmentMaker();
        $out = $apptmaker->makeAppointment();
        self::assertEquals($out, "Dane spotkania zakodowane w formacie BloggsCal\n");
    }

    public function testLessNaiveEncoder()
    {
        $apptmaker = new AppointmentMaker2(new BloggsApptEncoder());
        $out = $apptmaker->makeAppointment();
        self::assertEquals($out, "Dane spotkania zakodowane w formacie BloggsCal\n");
    }
}
