<?php
declare(strict_types = 1);

namespace popp\dodB\zestaw01\marklogic;

use popp\dodB\zestaw01\parse\Handler;
use popp\dodB\zestaw01\parse\Parser;
use popp\dodB\zestaw01\parse\Scanner;

use popp\dodB\zestaw01\interpreter\BooleanOrExpression;

/* listing 24.20 */
class BooleanOrHandler implements Handler
{
    public function handleMatch(Parser $parser, Scanner $scanner)
    {
        $comp1 = $scanner->getContext()->popResult();
        $comp2 = $scanner->getContext()->popResult();
        $scanner->getContext()->pushResult(new BooleanOrExpression($comp1, $comp2));
    }
}
