<?php
/**
 * Definiuje rdzenne funkcje poleceń.
 * Klasy hierarchii Command realizują konkretne zadania
 * w systemie za pośrednictwem metody execute()
 *
 * @package command
 * @author  Clarrie Grundie
 * @copyright 2013 Ambridge Technologies Ltd
 */
abstract class Command {

/**
 * Wykonuje zadanie ujęte w obiekcie klasy.
 * Klasy Command ujmują pojedyncze operacje; łatwo je dodawać do
 * projektu i z niego usuwać, a egzemplarze klas mogą być przechowywane
 * do późniejszego wykonania metody execute().
 *
 * @param  $context CommandContext wspólne dane kontekstowe
 * @return bool     false w przypadku niepowodzenia, true w przypadku powodzenia
 * @uses CommandContext
 * @link http://www.example.com More info
 */
    abstract function execute( CommandContext $context );
}
?>
