<?php

class CommandNotFoundException extends Exception {}

class CommandFactory {
    private static $dir = 'commands';

    static function getCommand( $action='Default' ) {
        if ( preg_match( '/\W/', $action ) ) {
            throw new Exception("niedozwolone znaki w akcji");
        }
        $class = UCFirst(strtolower($action))."Command";  
        $file = self::$dir.DIRECTORY_SEPARATOR."$class.php";
        if ( ! file_exists( $file ) ) {
            throw new CommandNotFoundException( "nie można znaleźć pliku '$file'" );
        }
        require_once( $file );
        if ( ! class_exists( $class ) ) {
            throw new CommandNotFoundException( "nie można znaleźć klasy '$class'" );
        }
        $cmd = new $class();
        return $cmd;
    }
}

class Controller {
    private $context;
    function __construct() {
        $this->context = new CommandContext();
    }

    function getContext() {
        return $this->context;
    }

    function process() {
        $action = $this->context->get('action');
        $action = ( is_null( $action ) ) ? "default" : $action;
        $cmd = CommandFactory::getCommand( $action );
        if ( ! $cmd->execute( $this->context ) ) {
            // obsługa niepowodzenia
        } else {
            // sukces
            // rozprowadzenie widoku
        }
    } 
}    




// ------------- rzeczy pomonicze
class User{
    private $name;
    function __construct( $name ) {
        $this->name = $name;
    }
}

class Registry {
    static function getMessageSystem() {
        return new MessageSystem();
    }
    static function getAccessManager() {
        return new AccessManager();
    }
}

class MessageSystem {
    function send( $mail, $msg, $topic ) {
        print "wiadomość $mail: $topic: $msg\n";
        return true;
    }

    function getError() {
        return "rozejść się, nie gapić się";
    }
}

class AccessManager {
    function login( $user, $pass ) {
        $ret = new User( $user );
        return $ret;
    }

    function getError() {
        return "rozejść się, nie gapić się";
    }
}

class CommandContext {
    private $params = array();
    private $error = "";

    function __construct() {
        $this->params = $_REQUEST;
    }

    function addParam( $key, $val ) { 
        $this->params[$key]=$val;
    }

    function get( $key ) { 
        if ( isset( $this->params[$key] ) ) {
            return $this->params[$key];
        }
        return null;
    }

    function setError( $error ) {
        $this->error = $error;
    }

    function getError() {
        return $this->error;
    }
}

$controller = new Controller();
$context = $controller->getContext();
$context->addParam('action', 'feedback' );
$context->addParam('email', 'bob@bob.com' );
$context->addParam('topic', 'mój mózg' );
$context->addParam('msg', 'wszystko o moim mózgu' );
$controller->process();
print $context->getError();

?>
