<?php

class XmlException extends Exception {
    private $error;

    function __construct( LibXmlError $error ) {
        $shortfile = basename( $error->file );
	print_r( $error );
        $msg = "[{$shortfile}, line {$error->line}, col {$error->column}] {$error->message}";
        $this->error = $error;
        parent::__construct( $msg, $error->code );
    }

    function getLibXmlError() {
        return $this->error;
    }
}

class FileException extends Exception { }
class ConfException extends Exception { }

class Conf {
    private $file;
    private $xml;
    private $lastmatch;

    function __construct( $file ) {
        $this->file = $file;
        if ( ! file_exists( $file ) ) {
            throw new Exception( "plik '$file' nie istnieje" );
        }
    }    

    function write() {
        if ( ! is_writeable( $this->file ) ) {
            throw new Exception("plik '{$this->file}' jest niemodyfikowalny");
        }
        file_put_contents( $this->file, $this->xml->asXML() );
    }

    function get( $str ) {
        $matches = $this->xml->xpath("/conf/item[@name=\"$str\"]");
        if ( count( $matches ) ) {
            $this->lastmatch = $matches[0];
            return (string)$matches[0];
        }
        return null;
    }

    function set( $key, $value ) {
        if ( ! is_null( $this->get( $key ) ) ) {
            $this->lastmatch[0]=$value;
            return;
        }
        $conf = $this->xml->conf;
        $this->xml->addChild('item', $value)->addAttribute( 'name', $key );
    }
}


class Runner {
    static function init() { 
        try {
            $fh = fopen("./log.txt","a");
            fputs( $fh, "start\n" );
            $conf = new Conf( dirname(__FILE__)."/conf.broken.xml" );
            print "użytkownik: ".$conf->get('user')."\n";
            print "host: ".$conf->get('host')."\n";
            $conf->set("pass", "newpass");
            $conf->write();
            fputs( $fh, "end\n" );
            fclose( $fh );
        } catch ( FileException $e ) {
            // permissions issue or non-existent file
            fputs( $fh, "wyjątek plikowy\n" );
            throw $e;
        } catch ( XmlException $e ) {
            fputs( $fh, "wyjątek xml\n" );
            // broken xml
        } catch ( ConfException $e ) {
            fputs( $fh, "wyjątek konfiguracji\n" );
            // wrong kind of XML file
        } catch ( Exception $e ) {
            fputs( $fh, "wyjątek ogólny\n" );
            // backstop: should not be called
        }
    }
}

Runner::init();

?>
