<?php
abstract class Lesson {
    private   $duration;
    private   $costStrategy;

    function __construct( $duration, CostStrategy $strategy ) {
        $this->duration = $duration;
        $this->costStrategy = $strategy;
    }

    function cost() {
        return $this->costStrategy->cost( $this );
    }

    function chargeType() {
        return $this->costStrategy->chargeType( );
    }

    function getDuration() {
        return $this->duration;
    }

    // reszta metod...
}


abstract class CostStrategy {
    abstract function cost( Lesson $lesson );
    abstract function chargeType();
}

class TimedCostStrategy extends CostStrategy {
    function cost( Lesson $lesson ) {
        return ( $lesson->getDuration() * 5 );
    }

    function chargeType() {
        return "stawka godzinowa";
    }
}

class FixedCostStrategy extends CostStrategy {
    function cost( Lesson $lesson ) {
        return 30;
    }

    function chargeType() {
        return "stawka stała";
    }
}

class Lecture extends Lesson {
    // implementacja właściwa dla wykładów (Lecture) ...
}

class Seminar extends Lesson {
    // implementacja właściwa dla seminariów (Seminar) ...
}

class RegistrationMgr {
    function register( Lesson $lesson ) {
        // jakieś operacje na obiekcie Lesson

        // powiadomienie zainteresowanych
        $notifier = Notifier::getNotifier();
        $notifier->inform( "nowe zajęcia: koszt ({$lesson->cost()})" );
    }
}

abstract class Notifier {
    
    static function getNotifier() {
        // pozyskanie konkretnej klasy odpowiednio do konfiguracji
        // albo innej logiki

        if ( rand(1,2) == 1 ) {
            return new MailNotifier();
        } else {
            return new TextNotifier();
        }
    }

    abstract function inform( $message );
}

class MailNotifier extends Notifier {
    function inform( $message ) {
        print "MAIL (powiadomienie): {$message}\n";
    }
}

class TextNotifier extends Notifier {
    function inform( $message ) {
        print "TEXT (powiadomienie): {$message}\n";
    }
} 
$lessons1 = new Seminar( 4, new TimedCostStrategy() );
$lessons2 = new Lecture( 4, new FixedCostStrategy() );
$mgr = new RegistrationMgr();
$mgr->register( $lessons1 );
$mgr->register( $lessons2 );

?>
