<?php
require_once( "closures.php" );

class Totalizer {
    static function warnAmount( $amt ) {
        $count=0;
        return function( $product ) use ( $amt, &$count ) {
            $count += $product->price;
            print "   suma: $count\n";
            if ( $count > $amt ) {
                print "   drogo: {$count}\n";
            }
        };
    }
}

$processor = new ProcessSale();
$processor->registerCallback( Totalizer::warnAmount( 8) );

$processor->sale( new Product( "buty", 6 ) );
print "\n";
$processor->sale( new Product( "kawa", 6 ) );
?>
