<?php
// tworzenie własnego filtru strumienia
class DirtyWordsFilter extends php_user_filter
{
    /**
     * @param resource $in       wejściowa brygada wiaderkowa
     * @param resource $out      wyjściowa brygada wiaderkowa
     * @param int      $consumed liczba zużytych bajtów
     * @param bool     $closing  ostatnia brygada wiaderkowa w strumieniu?
     */
    public function filter($in, $out, &$consumed, $closing)
    {
        $words = array('grime', 'dirt', 'grease');
        $wordData = array();
        foreach ($words as $word) {
            $replacement = array_fill(0, mb_strlen($word), '*');
            $wordData[$word] = implode('', $replacement);
        }
        $bad = array_keys($wordData);
        $good = array_values($wordData);

        // iteraca po wszystkich wiaderkach z wejściowej brygady
        while ($bucket = stream_bucket_make_writeable($in)) {
            // cenzurowanie brzydkich słów w danych z wiaderka
            $bucket->data = str_replace($bad, $good, $bucket->data);

            // inkrementacja ilości zużytych danych
            $consumed += $bucket->datalen;

            // wysłanie wiaderka w dół strumienia
            stream_bucket_append($out, $bucket);
        }

        return PSFS_PASS_ON;
    }
}
stream_filter_register('dirty_words_filter', 'DirtyWordsFilter');

// przykład użycia filtru
$handle = fopen('data.txt', 'rb');
stream_filter_append($handle, 'dirty_words_filter');
while (feof($handle) !== true) {
    echo fgets($handle);
}
fclose($handle);
