<?php
// 1. użycie autoloadera Composera
require 'vendor/autoload.php';

// 2. utworzenie egzemplarza klienta HTTP Guzzle
$client = new \GuzzleHttp\Client();

// 3. otwarcie i przeglądanie pliku CSV
$csv = new \League\Csv\Reader($argv[1]);
foreach ($csv as $csvRow) {
    try {
        // 4. Wysłanie żądania HTTP OPTIONS 
        $httpResponse = $client->options($csvRow[0]);

        // 5. sprawdzenie kodu odpowiedzi HTTP
        if ($httpResponse->getStatusCode() >= 400) {
            throw new \Exception();
        }
    } catch (\Exception $e) {
        // 6. wysłanie niedziałających adresów na wyjście standardowe
        echo $csvRow[0] . PHP_EOL;
    }
}
