<?php
class Whovian
{
    /**
     * @var string
     */
    protected $favoriteDoctor;

    /**
     * konstruktor
     * @param  string $favoriteDoctor
     */
    public function __construct($favoriteDoctor)
    {
        $this->favoriteDoctor = (string)$favoriteDoctor;
    }

    /**
     * powiedz
     * @return string
     */
    public function say()
    {
        return 'Najlepszy doktor to ' . $this->favoriteDoctor;
    }

    /**
     * odpowiedz
     * @param  string $input
     * @return string
     * @throws \Exception
     */
    public function respondTo($input)
    {
        $input = strtolower($input);
        $myDoctor = strtolower($this->favoriteDoctor);

        if (strpos($input, $myDoctor) === false) {
            throw new Exception(
                sprintf(
                    'W życiu! Najlepszym doktorem na świecie jest %s!',
                    $this->favoriteDoctor
                )
            );
        }

        return 'Zgadzam się!';
    }
}
