<?php
require dirname(__DIR__) . '/src/Whovian.php';

class WhovianTest extends PHPUnit_Framework_TestCase
{
    public function testSetsDoctorWithConstructor()
    {
        $whovian = new Whovian('Peter Capaldi');
        $this->assertAttributeEquals('Peter Capaldi', 'favoriteDoctor', $whovian);
    }

    public function testSaysDoctorName()
    {
        $whovian = new Whovian('David Tennant');
        $this->assertEquals('Najlepszym doktorem jest David Tennant', $whovian->say());
    }

    public function testRespondToInAgreement()
    {
        $whovian = new Whovian('David Tennant');

        $opinion = 'David Tennant jest najlepszym doktorem i koniec';
        $this->assertEquals('Zgadzam się!', $whovian->respondTo($opinion));
    }

    /**
     * @expectedException Exception
     */
    public function testRespondToInDisagreement()
    {
        $whovian = new Whovian('David Tennant');

        $opinion = 'W życiu. Matt Smith jest świetny!';
        $whovian->respondTo($opinion);
    }
}
