<?php

require __DIR__ . '/../../vendor/autoload.php';

use DesignPatterns\FactoryMethod\AbstractWriter;
use DesignPatterns\FactoryMethod\CsvWriter;
use DesignPatterns\FactoryMethod\JsonWriter;

function factoryMethodExample(AbstractWriter $writer)
{
    $exampleData = [
        ['dane3', 'dane4'],
        ['dane1', 'dane2'],
    ];

    $writer->write($exampleData);

    echo PHP_EOL;
}

echo "Wyprowadzanie danych przy użyciu klasy CsvWriter:" . PHP_EOL;

factoryMethodExample(new CsvWriter());

echo "Wyprowadzanie danych przy użyciu klasy JsonWriter:" . PHP_EOL;

factoryMethodExample(new JsonWriter());