<?php

declare(strict_types=1);

use GitHubActionsExample\Controller\ProductController;
use GitHubActionsExample\Controller\UserController;
use Laminas\Diactoros\ResponseFactory;

require __DIR__ . '/../vendor/autoload.php';

// Utwórz obiekt żądania.
$request = Laminas\Diactoros\ServerRequestFactory::fromGlobals();

// Zainicjuj router.
$responseFactory = new ResponseFactory();
$strategy = new League\Route\Strategy\JsonStrategy($responseFactory);
$router = new League\Route\Router();
$router->setStrategy($strategy);

// Zdefiniuj trasy.
$router->map(
    'GET',
    '/products',
    [
        ProductController::class,
        'get'
    ]
);

$router->map(
    'GET',
    '/users',
    [
        UserController::class,
        'get'
    ]
);

// Rozdysponuj żadanie, aby otrzymać obiekt odpowiedzi.
$response = $router->dispatch($request);

// Wyślij odpowiedź.
(new Laminas\HttpHandlerRunner\Emitter\SapiEmitter())->emit($response);
