<?php

declare(strict_types=1);

namespace OpenApiExample\Attributes\Controller;

use OpenApi\Attributes as OAT;

#[OAT\Info(
    version: '0.1',
    title: 'Interfejs API produktów',
)]
class ProductController
{
    #[OAT\Get(
        path: '/product',
        operationId: 'getProducts',
        parameters: [
            new OAT\Parameter(
                name: 'limit',
                description: 'Ile produktów zwracać naraz',
                in: 'query',
                required: false,
                schema: new OAT\Schema(
                    type: 'integer'
                ),
            ),
        ],
        responses: [
            new OAT\Response(
                response: 200,
                description: 'Zwraca dane produktów.',
            ),
        ]
    )]
    public function getProducts(): array
    {
        // ...
    }
}
