<?php

declare(strict_types=1);

namespace DesignPatterns\Observer;

class TightlyCoupledExample
{
    private int $id;

    public function __construct(
        private MailService $mailService
    ) {}

    public function cancelSubscription(): void
    {
        // Kod konieczny do faktycznego anulowania subskrypcji
        // ...

        $this->mailService->sendEmail(
            'sales@example.com',
            'Użytkownik ' . $this->id . ' anulował subskrypcję.'
        );
    }
}