<?php
declare(strict_types = 1); // dbamy o prawidłowe typy danych

define ('E_SQLITE', 1);
define ('E_MYSQL',  2);

class MyDB 
{
    private $db_pdo;

    /* Plik z bazą danych w formacie SQLite */
    private $db_file = 'kartoteka.db';

    /* Konfiguracja serwera MySQL */
    private $db_server = 'localhost';
    private $db_name   = 'db_php8';
    private $db_user   = 'db_php8';
    private $db_passwd = 'WETFD8toJyKLWtXC'; // u Ciebie będzie z pewnością inne :)

    public function __construct(private int $engine = E_SQLITE)
    {
        try {
            $this->db_pdo = match($this->engine) {
                // SQLite
                E_SQLITE => new PDO('sqlite:'.__DIR__.'/../'.$this->db_file),
                // MySQL
                E_MYSQL => new PDO(
                    "mysql:host=".$this->db_server.";dbname=".$this->db_name,
                    $this->db_user, 
                    $this->db_passwd,
                    [PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8"]
                )
            };
            
            // włącz obsługę wyjątków dla obsługi interfejsu PDO
            $this->db_pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        } catch (PDOException $e) {
            print "Błąd!: " . $e->getMessage();
            die();
        }
    }

    public function __destruct() {
        $this->db_pdo = null;
    }

    public function myQuery(string $sql) : array
    {
        // wyślij zapytanie do bazy i pobierz wyniki
        return $this->db_pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
    }

    public function mySearch(string $sql, ?string $search = '') : array
    {
        // wyślij zapytanie do bazy i pobierz wyniki
        $stmt = $this->db_pdo->prepare($sql);
        $stmt->execute(["%$search%", "%$search%"]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}