<?php
// Definicja prostego atrybutu dokumentacyjnego
#[Attribute]
class Description {
    public function __construct(
        public string $text
    ) {}
}

// Użycie atrybutu do opisania klasy
#[Description("Klasa umożliwia obliczenie pola trójkąta.")]
class Triangle {
    public float $a;
    public float $h;

    public function __construct(float $a, float $h) {
        $this->a = $a;
        $this->h = $h;
    }

    public function area(): float {
        return 0.5 * $this->a * $this->h;
    }
}