<?php
use PHPUnit\Framework\TestCase;

require_once "Triangle.php"; // testowana funkcja

class TriangleTest2 extends TestCase
{
    public function testArea()
    {
        // Typowe przypadki
        $this->assertEquals(12.0, triangle(6, 4));
        $this->assertEquals(0.0, triangle(0, 10));
        $this->assertEquals(7.5, triangle(5, 3));

        // Liczby zmiennoprzecinkowe
        $this->assertEquals(3.75, triangle(2.5, 3), '', 0.0001);
        $this->assertEquals(2.25, triangle(1.5, 3), '', 0.0001);
    }

    public function testANegative()
    {
        $this->expectException(InvalidArgumentException::class);
        triangle(-5, 4);
    }

    public function testHNegative()
    {
        $this->expectException(InvalidArgumentException::class);
        triangle(5, -4);
    }

    public function testAHNegative()
    {
        $this->expectException(InvalidArgumentException::class);
        triangle(-5, -4);
    }
}