<?php
class Produkt // definicja klasy
{
    private $netto;   // właściwość dostępna lokalnie
    public $vat = 23; // właściwość dostępna publicznie

    // konstruktor
    public function __construct(private string $nazwa, private int|float $brutto)
    {
        /* 
        PHP 8 automatycznie utworzy i zdefiniuje właściwości:
        $this->nazwa = $nazwa;
        $this->brutto = $brutto;
        */
        $this->netto = $this->setNetto(); // wywołaj metodę lokalną
    }

    public function drukuj() // metoda dostępna publicznie
    {
        printf(
        "Produkt: %s".PHP_EOL."Cena netto: %.2f PLN".PHP_EOL.
        "Podatek: %.2f %%".PHP_EOL."Cena brutto: %.2f PLN",
        $this->nazwa,
        $this->netto,
        $this->vat,
        $this->brutto
        );
    }

    private function setNetto() : int|float // metoda dostępna lokalnie
    {
        return $this->brutto / (1 + ($this->vat / 100)); // obliczanie ceny netto
    }
}

// tworzenie egzemplarza klasy
$owoc = new Produkt(nazwa: "Gruszka", brutto: 4.85);
print $owoc->drukuj(); // wywołanie metody publicznej