<?php
declare(strict_types = 1); // dbamy o prawidłowe typy danych

class MyBook extends MyDB
{
    public function __construct(private int $engine = E_SQLITE)
    {
        parent::__construct(engine: $engine);
    }

    public function books(string $search = '') : array
    {
        if ($search != '')
        {
            // wycinamy wszystko, co nie jest cyfrą, literą, podkreśleniem itp.
            $search = preg_replace('/[^0-9 a-z-!_\\p{L}]/u', '', $search);
        }

        // lista wszystkich książek
        // zmiana nazw pól na język angielski
        return $this->mySearch(sql: "
            SELECT
            id,
            autor as author,
            tytul as title,
            rok as year,
            stron as pages
            FROM ksiazki WHERE autor LIKE ? OR tytul LIKE ? ORDER BY id ASC;
        ", search: $search);
    }

    public function register() : array
    {
        // lista wszystkich książek
        // zmiana nazw pól na język angielski
        return $this->myQuery(sql: "
            SELECT
            w.id,
            w.data as date,
            k.tytul as title,
            k.rok as year,
            o.imie as name,
            o.nazwisko as surname
            FROM wypozyczenia AS w, ksiazki AS k, osoby AS o
            WHERE
            w.ksiazka = k.id AND w.osoba = o.id
            ORDER BY w.id ASC;
        ");
    }
}