<?php
use PHPUnit\Framework\TestCase;

require_once "prime.php"; // testowana funkcja

class PrimeTest extends TestCase
{
    // testujemy czy liczba jest liczbą pierwszą
    public function testIsPrime()
    {
        $this->assertTrue(is_prime(2));
        $this->assertTrue(is_prime(3));
        $this->assertTrue(is_prime(5));
        $this->assertTrue(is_prime(17));
    }

    // testujemy czy liczba nie jest liczbą pierwszą
    public function testIsNotPrime()
    {
        $this->assertFalse(is_prime(0));
        $this->assertFalse(is_prime(1));
        $this->assertFalse(is_prime(10));
        $this->assertFalse(is_prime(100));
    }

    // testujemy czy funkcja zwraca typ logiczny
    public function testTypeResult()
    {
        $result = is_prime(13);
        $this->assertIsBool($result);
    }
}