<?php
try {
    $db_file = 'kartoteka.db';

    // otwórz połączenie z bazą SQLite lub utwórz nowy plik dla bazy
    $db_pdo = new PDO('sqlite:'.__DIR__.'/'.$db_file);
    
    // włącz obsługę wyjątków dla obsługi interfejsu PDO
    $db_pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    print "Ile potrzebuję czasu na przeczytanie książki?".PHP_EOL;
    print "AUTOR\t\tTYTUŁ\t\t\tCZAS".PHP_EOL;
    
    // wyślij zapytanie do bazy i pobierz wyniki
    $wynik = $db_pdo->query("
    SELECT (((stron * 3) / 60) + 1) AS czas, autor, tytul
    FROM ksiazki
    ORDER BY stron DESC;
    ");
    
    // przetwórz pobrane rekordy i wydrukuj
    while ($wiersz = $wynik->fetch()) {
        printf(
            "%s\t%s\t%d godz.".PHP_EOL,
            $wiersz['autor'], $wiersz['tytul'], $wiersz['czas']
        );
    }

    $db_pdo = null; // zamknij połączenie z bazą

} catch (PDOException $e) {
    print "Błąd!: " . $e->getMessage();
    die();
}