<?php if (isset($blad)): ?>
    <p style="color: red;"><?= $blad ?></p>
<?php endif; ?>

<form method="POST">
    <label>Podaj maksymalną cenę:</label>
    <input type="number" step="0.01" name="max" value="<?= htmlspecialchars($maxCena ?? '') ?>" required>
    <button>Filtruj</button>
</form>

<?php if (!empty($produkty)): ?>
    <h2>Produkty do <?= number_format($maxCena, 2, ',', ' ') ?> zł:</h2>
    <table border="1" cellpadding="8">
        <tr><th>Produkt</th><th>Cena (zł)</th></tr>
        <?php foreach($produkty as $p): ?>
            <tr>
                <td><?= htmlspecialchars($p['nazwa']) ?></td>
                <td><?= number_format($p['cena'], 2, ',', ' ') ?></td>
            </tr>
        <?php endforeach; ?>
    </table>
<?php elseif (isset($maxCena)): ?>
    <p>Brak produktów spełniających warunek.</p>
<?php endif; ?>