<?php
try {
    $db_file = 'kartoteka.db';

    // otwórz połączenie z bazą SQLite lub utwórz nowy plik dla bazy
    $db_pdo = new PDO('sqlite:'.__DIR__.'/'.$db_file);
    
    // włącz obsługę wyjątków dla obsługi interfejsu PDO
    $db_pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    /* pobierz informacje o wypożyczeniach */
    $result = $db_pdo->query("
        SELECT w.id, w.data, k.tytul, o.imie, o.nazwisko
        FROM wypozyczenia AS w, ksiazki AS k, osoby AS o
        WHERE
        w.ksiazka = k.id AND w.osoba = o.id
        ORDER BY w.id ASC;
    ");

    print "ID\tDATA\t\tTYTUŁ KSIĄŻKI\t\tWYPOŻYCZAJĄCY".PHP_EOL;

    foreach ($result as $r) {
        printf(
            "%s\t%s\t%s\t%s %s".PHP_EOL, 
            $r['id'], $r['data'], $r['tytul'], $r['imie'], $r['nazwisko']
        );
    }

    $db_pdo = null; // zamknij połączenie z bazą

} catch (PDOException $e) {
    print "Błąd!: " . $e->getMessage();
    die();
}