<?php
#[Attribute]
class Description {
    public function __construct(public string $text) {}
}

#[Description("Klasa umożliwia obliczenie pola trójkąta.")]
class Triangle {
    public float $a;
    public float $h;

    public function __construct(float $a, float $h) {
        $this->a = $a;
        $this->h = $h;
    }

    public function area(): float {
        return 0.5 * $this->a * $this->h;
    }

    #[Deprecated("Użyj metody area() zamiast getArea()")]
    public function getArea(): float {
        return $this->area();
    }
}

$t = new Triangle(10, 5);
echo "Pole: " . $t->getArea(); // IDE może pokazać ostrzeżenie
