<?php
declare(strict_types=1);

namespace popp\r04\zestaw16;

require_once("vendor/autoload.php");

use popp\test\BaseUnit;

class Batch16Test extends BaseUnit 
{

    public function testRunner()
    {
        $val = $this->capture(function() { Runner::run(); });
$expected = <<<EXPECTED
street address: 441b Bakers Street
street address: 15 Albert Mews
street address: 34 West 24th Avenue

EXPECTED;
        self::assertEquals($expected, $val);
        
    }

    public function testRunnerShorter()
    {
        $val = $this->capture(function() { Runner::run2(); });
$expected = <<<EXPECTED
popp\r04\zestaw16\Address Object
(
    [number:popp\r04\zestaw16\Address:private] => 441b
    [street:popp\r04\zestaw16\Address:private] => Bakers Street
)

EXPECTED;
        self::assertEquals($expected, $val);
    }
}
