<?php

declare(strict_types=1);

/* listing 18.17 */
namespace popp\r18\zestaw03;

class User
{
    private string $pass;
    private ?string $failed;

    public function __construct(private string $name, private string $mail, string $pass)
    {
        if (strlen($pass) < 5) {
            throw new \Exception(
                "Hasło musi mieć co najmniej 5 znaków"
            );
        }

        $this->pass = $pass;
    }

    public function getMail(): string
    {
        return $this->mail;
    }

    public function getPass(): string
    {
        return $this->pass;
    }

    public function failed(string $time): void
    {
        $this->failed = $time;
    }
}
