<?php

declare(strict_types=1);

namespace popp\r05\zestaw07;

class ClassInfo
{

/* listing 05.64 */
    // class ClassInfo

    public static function getData(\ReflectionClass $class): string
	{
		$details = "";
		$name = $class->getName();
		
		$details .= ($class->isUserDefined())  ?  "$name to klasa definiowana przez użytkownika\n"     : "" ;
		$details .= ($class->isInternal())     ?  "$name to klasa wbudowana\n"         : "" ;
		$details .= ($class->isInterface())    ?  "$name definiuje interfejs\n"        : "" ;
		$details .= ($class->isAbstract())     ?  "$name to klasa abstrakcyjna\n" : "" ;
		$details .= ($class->isFinal())        ?  "$name to klasa finalna\n"     : "" ;
		$details .= ($class->isInstantiable()) ?  "Można tworzyć obiekty klasy $name\n"  : "Nie można tworzyć obiektów klasy $name\n" ;
		$details .= ($class->isCloneable())    ?  "Można klonować obiekty klasy $name\n"        : "Nie można klonować obiektów klasy $name\n" ;
		
		return $details;
	}
/* /listing 05.64 */


/* listing 05.70 */

    // class ClassInfo
    
    public static function methodData(\ReflectionMethod $method): string
	{
		$details = "";
		$name = $method->getName();
		
		$details .= ($method->isUserDefined())    ?  "$name to metoda definiowana przez użytkownika\n"      : ""  ;
		$details .= ($method->isInternal())       ?  "$name to metoda wbudowana\n" : "" ;
		$details .= ($method->isAbstract())       ?  "$name to metoda abstrakcyjna\n"      : "" ;
		$details .= ($method->isPublic())         ?  "$name to metoda publiczna\n" : "" ;
		$details .= ($method->isProtected())      ?  "$name to metoda chroniona\n"      : "" ;
		$details .= ($method->isPrivate())        ?  "$name to metoda prywatna\n" : "" ;
		$details .= ($method->isStatic())         ?  "$name to metoda statyczna\n"  : "" ;
		$details .= ($method->isFinal())          ?  "$name to metoda finalna\n"   : "" ;
		$details .= ($method->isConstructor())    ?  "$name to konstruktor\n"      : "" ;
		$details .= ($method->returnsReference()) ?  "$name zwraca referencję (nie wartość)\n"      : "" ;
		
		return $details;
	}
/* /listing 05.70 */

/* listing 05.75 */

    // class ClassInfo
    public static function argData(\ReflectionParameter $arg): string
    {
        $details = "";
        $declaringclass = $arg->getDeclaringClass();
        $name  = $arg->getName();
        

        $position = $arg->getPosition();
        $details .= "\$$name jest na pozycji $position\n";
        if ($arg->hasType()) {
            $type = $arg->getType();
            $typenames = [];
            if ($type instanceof \ReflectionUnionType) {
                $types = $type->getTypes();
                foreach ($types as $utype) {
                    $typenames[] = $utype->getName();
                }
            } else {
                $typenames[] = $type->getName();
            }
            $typename = implode("|", $typenames);
            $details .= "\$$name powinien być typu {$typename}\n";
        }
      
        if ($arg->isPassedByReference()) {
            $details .= "\${$name} jest przekazywany przez referencję\n";
        }

        if ($arg->isDefaultValueAvailable()) {
            $def = $arg->getDefaultValue();
            $details .= "\${$name} ma wartość domyślną: $def\n";
        }

        if ($arg->allowsNull()) {
            $details .= "\${$name} może mieć wartość null\n";
        }

        return $details;
    }
/* /listing 05.75 */
}
