<?php

declare(strict_types=1);

namespace popp\r04\zestaw11;

class Runner
{
    public static function run()
    {
        self::init();
    }

    public static function run2()
    {
        self::init2();
    }

    public static function run3()
    {
        self::init3();
    }

/* listing 04.74 */
    public static function init(): void
    {
        try {
            $fh = fopen("/tmp/log.txt", "a");
            fputs($fh, "start\n");
            $conf = new Conf(dirname(__FILE__) . "/conf.broken.xml");
            print "user: " . $conf->get('user') . "\n";
            print "host: " . $conf->get('host') . "\n";
            $conf->set("pass", "newpass");
            $conf->write();
            fputs($fh, "end\n");
            fclose($fh);
        } catch (FileException $e) {
            // błąd uprawnień lub brak pliku
            fputs($fh, "wyjątek pliku\n");
            throw $e;
        } catch (XmlException $e) {
            fputs($fh, "wyjątek xml\n");
            // wadliwy xml
        } catch (ConfException $e) {
            fputs($fh, "wyjątek konfiguracji\n");
            // zły rodzaj pliku XML
        } catch (\Exception $e) {
            fputs($fh, "wyjątek ogólny\n");
            // zabezpieczenie: nie powinno dojść do tego wywołania
        }
    }
/* /listing 04.74 */

/* listing 04.75 */
    public static function init2(): void
    {
        $fh = fopen("/tmp/log.txt", "a");
        try {
            fputs($fh, "start\n");
            $conf = new Conf(dirname(__FILE__) . "/conf.not-there.xml");
            print "user: " . $conf->get('user') . "\n";
            print "host: " . $conf->get('host') . "\n";
            $conf->set("pass", "newpass");
            $conf->write();
        } catch (FileException $e) {
            // błąd uprawnień lub brak pliku
            fputs($fh, "wyjątek pliku\n");
            //throw $e;
        } catch (XmlException $e) {
            fputs($fh, "wyjątek xml\n");
            // wadliwy xml
        } catch (ConfException $e) {
            fputs($fh, "wyjątek konfiguracji\n");
            // zły rodzaj pliku XML
        } catch (Exception $e) {
            fputs($fh, "wyjątek ogólny\n");
            // zabezpieczenie: nie powinno dojść do tego wywołania
        } finally {
            fputs($fh, "end\n");
            fclose($fh);
        }
    }
/* /listing 04.75 */

    public static function init3(): void
    {
/* listing 04.80 */
        try {
            eval("illegal code");
        } catch (\Error $e) {
            print get_class($e) . "\n";
            print $e->getMessage();
        } catch (\Exception $e) {
            // obsługa wyjątku
        }
/* /listing 04.80 */
    }
}
