<?php
declare(strict_types=1);

namespace popp\r09\zestaw03;

require_once("vendor/autoload.php");

use popp\test\BaseUnit;
use popp\r04\zestaw02\DbGenerate;

class Batch03Test extends BaseUnit 
{

    public function testRunner()
    {
        $val = $this->capture(function() { Runner::run(); });
        //print $val;
        $test = "mary: (zadzwonię do ojca)|(zadzwonię do prawnika)|(spakuję manatki)";
        self::assertMatchesRegularExpression("/$test/", $val);
        $test = "bob: (zadzwonię do ojca)|(zadzwonię do prawnika)|(spakuję manatki)";
        self::assertMatchesRegularExpression("/$test/", $val);
        $test = "harry: (zadzwonię do ojca)|(zadzwonię do prawnika)|(spakuję manatki)";
        self::assertMatchesRegularExpression("/$test/", $val);
    }

    function testShopProductGenerate()
    {
        $dbgen = new DbGenerate();
        $pdo = $dbgen->getPDO();

        $obj = ShopProduct::getInstance(1, $pdo);
        //print_r($obj);
        self::assertEquals("moja antonia", $obj->getTitle());
        $obj = ShopProduct::getInstance(2, $pdo);
        //print_r($obj);
        self::assertEquals("london calling", $obj->getTitle());
        $obj = ShopProduct::getInstance(3, $pdo);
        //print_r($obj);
        self::assertEquals("soap", $obj->getTitle());
    }
}
