<?php

declare(strict_types=1);

namespace popp\r24\zestaw01\marklogic;

use popp\r24\zestaw01\parse\Handler;
use popp\r24\zestaw01\parse\Parser;
use popp\r24\zestaw01\parse\Scanner;
use popp\r24\zestaw01\interpreter\BooleanAndExpression;

/* listing 24.24 */
class BooleanAndHandler implements Handler
{
    public function handleMatch(Parser $parser, Scanner $scanner): void
    {
        $comp1 = $scanner->getContext()->popResult();
        $comp2 = $scanner->getContext()->popResult();
        $scanner->getContext()->pushResult(new BooleanAndExpression($comp1, $comp2));
    }
}
