<?php

declare(strict_types=1);

namespace popp\r24\zestaw01;

use popp\r24\zestaw01\parse\Context;
use popp\r24\zestaw01\parse\Scanner;
use popp\r24\zestaw01\parse\StringReader;
use popp\r24\zestaw01\marklogic\MarkParse;

class Runner
{
    public static function run(): void
    {
        // runner code here

        $questions = [
            "ile boków ma pięciokąt?" => '$input equals "pięć" or $input equals "5"',
            "podaj imię dziecka" => '$input equals "adam" or $input equals "ewa"',
            "życie zaczyna się po" => '$input equals "czterdziestce" or $input equals "40"'
        ];

        $answers = ["pięć", "adam", "40"];

        foreach ($questions as $prompt => $mark) {
            print "$prompt\n";
            $marker = new MarkLogicMarker($mark);
            $result = false;

            do {
                $line = array_shift($answers);

                //$fh = fopen( 'php://stdin', 'r' );
                //$line = fgets( $fh );
                //$line = trim( $line );

                $question = new TextQuestion($prompt, $marker);

                if ($result = $question->mark($line)) {
                    print "dobra odpowiedź!\n";
                } else {
                    print "spróbuj jeszcze raz\n";
                }
            } while (! $result);
        }
    }

    public static function run2(): void
    {
/* listing 24.06 */
        $context = new Context();
        $user_in = "\$input equals '4' or \$input equals 'cztery'";
        $reader = new StringReader($user_in);
        $scanner = new Scanner($reader, $context);

        while ($scanner->nextToken() != Scanner::EOF) {
            print $scanner->token();
            print "   {$scanner->charNo()}";
            print "   {$scanner->getTypeString()}\n";
        }
/* /listing 24.06 */
    }

    public static function run3(): void
    {
        //$input      = '4';
        //$statement = "( \$input equals '4' or  \$input equals 'cztery' )";
        $input      = 'pacha';
        $statement = "( \$input equals 'pięć' or \$input equals 'pacha')";

        $engine = new MarkParse($statement);
        $result = $engine->evaluate($input);
        print "wejście: $input test: $statement\n";

        if ($result) {
            print "prawda!\n";
        } else {
            print "fałsz!\n";
        }
    }

    public static function run4(): void
    {
/* listing 24.25 */
        $input      = 'pięć';
        $statement = "( \$input equals 'pięć')";
        $engine = new MarkParse($statement);
        $result = $engine->evaluate($input);
        print "wejście: $input test: $statement\n";

        if ($result) {
            print "true!\n";
        } else {
            print "false!\n";
        }
/* /listing 24.25 */
    }

    public static function run5(): void
    {
        // wyrzuci wyjątek
        $input      = 'pięć';
        $statement = "( \$input broken equals xxx 'pięć')";
        $engine = new MarkParse($statement);
        $result = $engine->evaluate($input);
    }
}
