<?php

/* listing 10.38 */

function getProductFileLines(string $file): array
{
    return file($file);
}

function getProductObjectFromId(string $id, string $productname): Product
{
    // przeszukiwanie bazy danych
    return new Product($id, $productname);
}

function getNameFromLine(string $line): string
{
    if (preg_match("/.*-(.*)\s\d+/", $line, $array)) {
        return str_replace('_', ' ', $array[1]);
    }
    return '';
}

function getIDFromLine($line): int|string
{
    if (preg_match("/^(\d{1,3})-/", $line, $array)) {
        return $array[1];
    }
    return -1;
}

class Product
{
    public string $id;
    public string $name;

    public function __construct(string $id, string $name)
    {
        $this->id = $id;
        $this->name = $name;
    }
}
/* /listing 10.38 */
