<?php

declare(strict_types=1);

namespace popp\r09\zestaw15;

use popp\r09\zestaw11\Sea;
use popp\r09\zestaw11\Plains;
use popp\r09\zestaw11\Forest;

/* listing 09.63 */
class TerrainFactory
{
    #[InjectConstructor(Sea::class, Plains::class, Forest::class)]
    public function __construct(private Sea $sea, private Plains $plains, private Forest $forest)
    {
    }

    public function getSea(): Sea
    {
        return clone $this->sea;
    }

    public function getPlains(): Plains
    {
        return clone $this->plains;
    }

    public function getForest(): Forest
    {
        return clone $this->forest;
    }
}
